/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

// I also parameterised the loop counts for flexibility and rearranged
// things for efficiency. Though it looks different it is still almost
// the same shader as the original I took from GlsSandbox.com, TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(2.0*scaled_gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

#ifdef GL_ES
precision mediump float;
#endif

// uniform float time;
// uniform vec2 resolution;

// The original version of this shader caused some stuttering on my  laptop  but
// I have reorganised the shader's code to improve its efficiency and no  longer
// have a problem.  If  the scene stutters then change the values N1 and N2 to
// 10 in order to reduce the load on the GPU. Note, using other values for these
// parameters changes the overall pattern produced by the shader but having both
// equal to 10 keeps the same basic pattern as the original had with 20. TheEmu.
 
#define N1 20 // Number of rings of lights // Original value was 20
#define N2 20 // Number of lights per ring // Original value was 20

const float brightness = 0.6 / float(N1*N2);
const float rotationVelocity = 2.0;
const vec3  color = vec3 ( 0.05, 0.50, 1.00 );

const float f1 = 0.100;
const float f2 = 0.200;
const float f3 = 0.250;
const float f4 = 0.125;

float amplitude = ( cos(time*f1) + sin(time*f2) ) * 0.5;
vec2  center = vec2 ( sin(time*f3), cos(time*f4) );

vec2 view = ( scaled_gl_FragCoord.xy*2.0 - resolution ) / resolution.y;

float TwoPi = radians(360.0);  // NVIDIA doesn't allow this as a const

const float k0 = 1.0 / float(N1);
const float k1 = 1.0 / float(N2);
      float k2 = TwoPi * 7.0;  // NVIDIA doesnt allow this as a const
      float k3 = TwoPi * 3.0;  // NVIDIA doesnt allow this as a const
      float k4 = TwoPi * k1;   // NVIDIA doesnt allow this as a const

void main( void )
 {

   float a = 0.0;

   for( int j=0; j<N1; j++ )
    {
      float b = float(j) * k0;
      float c = sin(b*time) * rotationVelocity;
      vec2  d = vec2(cos(k2*b),sin(k3*b)) + center;

      for( int i=0; i<N2; i++ )
       { a += 1.0 / distance ( view, vec2(cos(c),sin(c))*amplitude + d );
         c += k4;
      }
   }

   gl_FragColor = vec4(color,1.0) * a * brightness;
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15

}